# FreeSql 简介

FreeSql 是轻量化、可扩展和跨平台版的 .NETStandard 数据访问技术实现。

FreeSql 可用作对象关系映射程序 (O/RM)，以便于开发人员能够使用 .NETStandard 对象来处理数据库，不必经常编写大部分数据访问代码。

FreeSql 支持 MySql/SqlServer/PostgreSQL 数据库技术实现。

## 模型

FreeSql 使用模型执行数据访问，模型由实体类表示数据库表或视图，用于查询和保存数据。 有关详细信息，请参阅创建模型。

可从现有数据库生成实体模型，提供 IDbFirst 生成实体模型。

或者手动创建模型，基于模型创建或修改数据库，提供 ICodeFirst 同步结构的 API（甚至可以做到开发阶段自动同步）。

```csharp
using FreeSql.DataAnnotations;
using System;

public class Blog
{
    [Column(IsIdentity = true, IsPrimary = true)]
    public int BlogId { get; set; }
    public string Url { get; set; }
    public int Rating { get; set; }
}

public class Post
{
    public int PostId { get; set; }
    public string Title { get; set; }
    public string Content { get; set; }

    public int BlogId { get; set; }
    public Blog Blog { get; set; }
}
```

## 声明

```csharp
var connstr = "Data Source=127.0.0.1;Port=3306;User ID=root;Password=root;" + 
    "Initial Catalog=cccddd;Charset=utf8;SslMode=none;Max pool size=10";

IFreeSql fsql = new FreeSql.FreeSqlBuilder()
    .UseConnectionString(FreeSql.DataType.MySql, connstr)
    .UseSlave("connectionString1", "connectionString2") //使用从数据库，支持多个

    .UseLogger(null) //使用日志，不指定默认输出控制台 ILogger
    .UseCache(null) //使用缓存，不指定默认使用内存 IDistributedCache

    .UseAutoSyncStructure(true) //自动同步实体结构到数据库
    .UseSyncStructureToLower(true) //转小写同步结构
    .Build();
```

注意： IFreeSql 在项目中应以单例声明，而不是在每次使用的时候创建。

## 查询

```csharp
var blogs = fsql.Select<Blog>
    .Where(b => b.Rating > 3)
    .OrderBy(b => b.Url)
    .ToList();
```

## 插入

```csharp
var blog = new Blog { Url = "http://sample.com" };
blog.BlogId = (int)fsql.Insert<Blog>()
    .AppendData(blog)
    .ExecuteIdentity();
```

## 更新

```csharp
fsql.Update<Blog>()
    .Set(b => b.Url, "http://sample2222.com")
    .Where(b => b.Url == "http://sample.com")
    .ExecuteAffrows();
```

## 删除

```csharp
fsql.Delete<Blog>()
    .Where(b => b.Url == "http://sample.com")
    .ExecuteAffrows();
```

## 后续步骤

有关介绍性教程，请参阅 [FreeSql 入门]()。
